import math

def smooth(r,rO,rc,cs):
  if (r < rO):
    return 1.0
  elif (r > rc):
    return 0.0
  else:
    return (c[0] + c[1] * r + c[2] * r**2 + c[3] * r**3 + c[4] * r**4 + c[5] * r**5)

def lj(r,ep,sig):
  return (4.0 * ep * ((sig/r)**12 - (sig/r)**6))

rO = 0.6
rc = 6.0

denom = (rO**5 - rc**5) / 120.0 - (rO * rc * (rO**3 - rc**3)) / 24.0 + rO * rO * rc * rc * (rO - rc) / 12.0
esmC5 = 1.0 / 20.0 / denom
esmC4 = -(rO + rc) / 8.0 / denom
esmC3 = (rO * rO + 4.0 * rO * rc + rc * rc) / 12.0 / denom
esmC2 = (-rO * rc * (rO + rc)) / 4.0 / denom
esmC1 = (rO * rO * rc * rc) / 4.0 / denom
esmC0 = (-rc**5 / 120.0 + rO * rc**4 / 24.0 - rO * rO * rc**3 / 12.0) / denom
norm = 4.0 * 3.141592653589 * (rO**3 / 3.0 + esmC5 * (rc**8 - rO**8) / 8.0 + esmC4 * (rc**7 - rO**7) / 7.0 + esmC3 * (rc**6 - rO**6) / 6.0 + esmC2 * (rc**5 - rO**5) / 5.0 + esmC1 * (rc**4 - rO**4) / 4.0 + esmC0 * (rc**3 - rO**3) / 3.0)
c = [esmC0,esmC1,esmC2,esmC3,esmC4,esmC5]

#a = -1.88891
#b = -0.410626
epsilon = -math.exp(-0.3)/40.0 / (2.0 * 0.8**12 - 0.8**6)
sigma = 0.48
shift = -2.0 * math.exp(-0.3) - 4.0 * epsilon * (0.8**12 - 0.8**6)
print(epsilon, sigma, shift)
a = -2.0
b = -0.5
with open("guessExp.dat",'wt') as fpo:
  dz = 0.001
  z = 0.001
  while (z <= 6.000000001):
    ljp = lj(z,epsilon,sigma)+shift
    fpo.write("%g %g %g \n" % (z,ljp,a * math.exp(b*z) * smooth(z,rO,rc,c)))
    z += dz
